	subroutine OUT(iout, idbg, ipost, Ne, Nn, &
			Nc, C, T, w, &
			ie, Qde1, Qde2, x, D)	
! write solver output, C, T and nodal fluxes

	implicit none
	integer iout, idbg, ipost
	integer Ne, Nn				! array parameters
	real*8 Qde1(4)				! element arrays
	real*8 Qde2(4)				! element arrays
	integer ie(Ne,5)			! global connectivity array
	real*8 x(Nn,2)				! global coordinates array
	real*8 C   (Nn), T   (Nn)		! global  arrays
	real*8 D(Ne,2,2)
	real*8 w(Nn)				! work array
	integer Nc

	integer e, i, j
	real*8 Ce(4)				! local element arrays

	write(idbg,'(a)') ' --- OUT ---'	! ### TEMPORARY ###

	Nc = Nc + 1		! counter for Gmsh

! output C
	write(ipost,'(a)') '$NodeData'
	write(ipost,'(i10, a)') 1, '	// number-of-string-tags'
	write(ipost,'(a)') '"h"		// < "string-tag" > ...'
	write(ipost,'(i10, a)') 1, '	// number-of-real-tags'
	write(ipost,'(g, a)') 0, '	// < real-tag > ... time'
	write(ipost,'(i10, a)') 3, '	// number-of-integer-tags'
	write(ipost,'(i10, a)') Nc, '	// step #'
	write(ipost,'(i10, a)') 1, '	// number of components'
	write(ipost,'(i10, a)') Nn, '	// number of nodes'
	do i = 1, Nn
	  write(ipost,'(i10, 3g)') i,  C(i)
	enddo		! i
	write(ipost,'(a)') '// node-number value ...'
	write(ipost,'(a)') '$EndNodeData'
	write(ipost,*)
! output T
	write(ipost,'(a)') '$NodeData'
	write(ipost,'(i10, a)') 1, '	// number-of-string-tags'
	write(ipost,'(a)') '"T"		// < "string-tag" > ...'
	write(ipost,'(i10, a)') 1, '	// number-of-real-tags'
	write(ipost,'(g, a)') 0, '	// < real-tag > ... time'
	write(ipost,'(i10, a)') 3, '	// number-of-integer-tags'
	write(ipost,'(i10, a)') Nc, '	// step #'
	write(ipost,'(i10, a)') 1, '	// number of components'
	write(ipost,'(i10, a)') Nn, '	// number of nodes'
	do i = 1, Nn
	  write(ipost,'(i10, 3g)') i,  T(i)
	enddo		! i
	write(ipost,'(a)') '// node-number value ...'
	write(ipost,'(a)') '$EndNodeData'
	write(ipost,*)

! element center flux, q
! compute and write {q} = [Qd]{C}
	write(ipost,'(a)') '$ElementData'
	write(ipost,'(i10, a)') 1, '	// number-of-string-tags'
	write(ipost,'(a)') '"q"		// < "string-tag" > ...'
	write(ipost,'(i10, a)') 1, '	// number-of-real-tags'
	write(ipost,'(g, a)') 0.d0, '	// < real-tag > ... time'
	write(ipost,'(i10, a)') 3, '	// number-of-integer-tags'
	write(ipost,'(i10, a)') Nc, '	// step #'
	write(ipost,'(i10, a)') 3, '	// number of components'
	write(ipost,'(i10, a)') Ne, '	// number of elements'
	do e = 1, Ne
	  w(1:2) = 0.		! use matrix form
	  do j = 1,4
! calculate nodal flux matrices
	    call SHAPEQ(iout, idbg, Ne, Nn, D, Qde1, Qde2, &
			 ie, x, e)
	    Ce(j) = C( ie(e,j) )			! element C(@ j-th node)
	    w(1) = w(1) + Qde1(j)*Ce(j)
	    w(2) = w(2) + Qde2(j)*Ce(j)
	  enddo		! j
	  write(ipost,'(i10, 3g)') e, w(1), w(2), 0.
	enddo		! e
	write(ipost,'(a)') '// node-number value ...'
	write(ipost,'(a)') '$EndElementData'
	write(ipost,*)

	return
	end

